<!--${cfg.moduleName}-->
<template>
    <div>
        <el-form :model="form"   label-position="right" label-width="80px" :inline="true">
            <#list table.fields as field>
                <#list cfg.forms as form>
                    <#if field.name == form.fieldName>
                        <#if form.controllerType == "单行文本">
                            <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                <el-input v-model="form.${field.propertyName}" size="small" style="width: 200px;"></el-input>
                            </el-form-item>
                        <#elseif form.controllerType == "多行文本">
                            <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                <el-input v-model="form.${field.propertyName}" size="small"  type="textarea"  :rows="2" style="width: 200px;"></el-input>
                            </el-form-item>
                        <#elseif form.controllerType == "日期">
                            <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                <el-date-picker v-model="form.${field.propertyName}" size="small" type="date" value-format="yyyy-MM-dd"
                                                style="width: 200px;"></el-date-picker>
                            </el-form-item>
                        <#elseif form.controllerType == "日期时间">
                            <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                <el-date-picker v-model="form.${field.propertyName}" size="small"  type="datetime" value-format="yyyy-MM-dd HH:mm:ss"
                                                style="width: 200px;"></el-date-picker>
                            </el-form-item>
                        </#if>
                    </#if>
                </#list>
            </#list>
        </el-form>
    </div>
</template>

<script>
    import {
        mapState
    } from 'vuex'
    import axios from '@/axios'
    export default {
        computed: {
            ...mapState({
                businessId: state => state.process.businessId,
            })
        },
        data() {
            return {
                form: {
                },
            }
        },
        mounted() {
            this.getBusiness()
        },
        methods: {
            getBusiness() {
                var url = '${cfg.moduleName}/${entity}/queryByPK.do'
                var param = {
                    id: this.businessId
                }
                axios.get(url, param).then(response => {
                    if (response.data.code == '0') {
                        this.form = response.data.data
                    } else {
                        this.$message({
                            type: 'error',
                            message: '操作失败!' + response.data.msg
                        });
                    }
                });
            }
        },

    }
</script>

<style>
</style>
