/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.shinsoft.generator.mapper.LowCodeFieldMapper;
import com.shinsoft.generator.mapper.LowCodeMapper;
import com.shinsoft.generator.mapper.LowCodePersonalMapper;
import com.shinsoft.generator.model.LowCode;
import com.shinsoft.generator.model.LowCodeField;
import com.shinsoft.generator.model.LowCodePersonal;
import com.shinsoft.generator.service.LowCodePersonalService;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResponseCodeMsg;
import com.shinsoft.tools.model.common.ResultJSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LowCodePersonalServiceImpl
implements LowCodePersonalService {
    ResultJSON resultJSON;
    @Autowired
    LowCodePersonalMapper lowCodePersonalMapper;
    @Autowired
    LowCodeMapper lowCodeMapper;
    @Autowired
    LowCodeFieldMapper lowCodeFieldMapper;

    @Override
    public ResultJSON queryByUserIdMenuId(String userId, String menuId, String tName) {
        List<LowCodePersonal> list = this.lowCodePersonalMapper.selectByByUserIdMenuId(userId, menuId, tName);
        if (CollectionUtils.isEmpty(list)) {
            list = this.lowCodePersonalMapper.selectByByUserIdMenuId("default", menuId, tName);
        }
        this.resultJSON = JSONTools.toResultJSON(list);
        return this.resultJSON;
    }

    @Override
    public ResultJSON queryTNameByUserIdMenuId(String userId, String menuId) {
        List<String> list = this.lowCodePersonalMapper.selectTNameByByUserIdMenuId("default", menuId);
        this.resultJSON = JSONTools.toResultJSON(list);
        return this.resultJSON;
    }

    @Override
    public ResultJSON modify(String userId, String menuId, String row, String col, String tName) {
        LowCodePersonal lowCodePersonal = (LowCodePersonal)JSON.parseObject((String)row, (TypeReference)new TypeReference<LowCodePersonal>(){}, (Feature[])new Feature[0]);
        this.checkPersonal(lowCodePersonal, userId, menuId, tName);
        lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdProp(userId, menuId, lowCodePersonal.getProp(), tName);
        if (col.equals("showFlag")) {
            if (lowCodePersonal.getShowFlag().equals("1")) {
                lowCodePersonal.setShowFlag("0");
            } else if (lowCodePersonal.getShowFlag().equals("0")) {
                lowCodePersonal.setShowFlag("1");
            } else {
                lowCodePersonal.setShowFlag("1");
            }
        } else if (col.equals("sortable")) {
            if (lowCodePersonal.getSortable().equals("1")) {
                lowCodePersonal.setSortable("0");
            } else if (lowCodePersonal.getSortable().equals("0")) {
                lowCodePersonal.setSortable("1");
            } else {
                lowCodePersonal.setSortable("1");
            }
        } else if (col.equals("align")) {
            if (lowCodePersonal.getAlign().equals("left")) {
                lowCodePersonal.setAlign("center");
            } else if (lowCodePersonal.getAlign().equals("center")) {
                lowCodePersonal.setAlign("right");
            } else if (lowCodePersonal.getAlign().equals("right")) {
                lowCodePersonal.setAlign("left");
            } else {
                lowCodePersonal.setAlign("center");
            }
        } else if (col.equals("exportFlag")) {
            if (lowCodePersonal.getExportFlag().equals("1")) {
                lowCodePersonal.setExportFlag("0");
            } else if (lowCodePersonal.getExportFlag().equals("0")) {
                lowCodePersonal.setExportFlag("1");
            } else {
                lowCodePersonal.setExportFlag("1");
            }
        }
        this.lowCodePersonalMapper.updateByPrimaryKey(lowCodePersonal);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON move(String userId, String menuId, String row, String type, String tName) throws Exception {
        LowCodePersonal lowCodePersonal = (LowCodePersonal)JSON.parseObject((String)row, (TypeReference)new TypeReference<LowCodePersonal>(){}, (Feature[])new Feature[0]);
        List<LowCodePersonal> list = this.checkPersonal(lowCodePersonal, userId, menuId, tName);
        if (type.equals("up")) {
            if (lowCodePersonal.getSort() <= 1) {
                throw new Exception("\u8be5\u5217\u5df2\u5728\u6700\u524d\u7aef\uff0c\u65e0\u6cd5\u79fb\u52a8");
            }
            LowCodePersonal up = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort(userId, menuId, lowCodePersonal.getSort() - 1, tName);
            LowCodePersonal down = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort(userId, menuId, lowCodePersonal.getSort(), tName);
            up.setSort(lowCodePersonal.getSort());
            down.setSort(lowCodePersonal.getSort() - 1);
            this.lowCodePersonalMapper.updateByPrimaryKey(up);
            this.lowCodePersonalMapper.updateByPrimaryKey(down);
        } else if (type.equals("down")) {
            if (lowCodePersonal.getSort() >= list.size()) {
                throw new Exception("\u8be5\u5217\u5df2\u5728\u6700\u540e\u7aef\uff0c\u65e0\u6cd5\u79fb\u52a8");
            }
            LowCodePersonal up = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort(userId, menuId, lowCodePersonal.getSort(), tName);
            LowCodePersonal down = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort(userId, menuId, lowCodePersonal.getSort() + 1, tName);
            up.setSort(lowCodePersonal.getSort() + 1);
            down.setSort(lowCodePersonal.getSort());
            this.lowCodePersonalMapper.updateByPrimaryKey(up);
            this.lowCodePersonalMapper.updateByPrimaryKey(down);
        }
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON widthDragend(String userId, String menuId, String prop, String width, String tName) {
        LowCodePersonal lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdProp(userId, menuId, prop, tName);
        if (lowCodePersonal == null) {
            lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdProp("default", menuId, prop, tName);
        }
        List<LowCodePersonal> list = this.checkPersonal(lowCodePersonal, userId, menuId, tName);
        lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdProp(userId, menuId, prop, tName);
        lowCodePersonal.setWidth(width);
        this.lowCodePersonalMapper.updateByPrimaryKey(lowCodePersonal);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON indexDragend(String userId, String menuId, int oldSort, int newSort, String tName) {
        LowCodePersonal lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort(userId, menuId, oldSort, tName);
        if (lowCodePersonal == null) {
            lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort("default", menuId, oldSort, tName);
        }
        List<LowCodePersonal> list = this.checkPersonal(lowCodePersonal, userId, menuId, tName);
        lowCodePersonal = this.lowCodePersonalMapper.selectByByUserIdMenuIdSort(userId, menuId, oldSort, tName);
        if (newSort > oldSort) {
            this.lowCodePersonalMapper.updateForDragend(userId, menuId, tName, oldSort + 1, newSort, -1);
        } else if (newSort < oldSort) {
            this.lowCodePersonalMapper.updateForDragend(userId, menuId, tName, newSort, oldSort - 1, 1);
        }
        lowCodePersonal.setSort(newSort);
        this.lowCodePersonalMapper.updateByPrimaryKey(lowCodePersonal);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON restore(String userId, String menuId, String tName) {
        this.lowCodePersonalMapper.deleteByUserIdMenuIdTname(userId, menuId, tName);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON add(String json) {
        List list = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<LowCodePersonal>>(){}, (Feature[])new Feature[0]);
        if (list.size() == 0) {
            return JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)"\u65e0\u6570\u636e");
        }
        String menuId = ((LowCodePersonal)list.get(0)).getMenuId();
        String tName = ((LowCodePersonal)list.get(0)).getTName();
        this.lowCodePersonalMapper.deleteByUserIdMenuIdTname("default", menuId, tName);
        for (int i = 0; i < list.size(); ++i) {
            this.lowCodePersonalMapper.insert((LowCodePersonal)list.get(i));
        }
        return JSONTools.toResultJSON((Object)"");
    }

    @Override
    public ResultJSON generate(String userId, String tableName) {
        LowCode lowCode = this.lowCodeMapper.selectByTableName(tableName);
        List<LowCodeField> fields = this.lowCodeFieldMapper.selectByFid(lowCode.getId());
        LowCodePersonal personal = null;
        LowCodeField field = null;
        this.lowCodePersonalMapper.deleteByUserIdMenuIdTname("default", lowCode.getMenuId(), lowCode.getTName());
        for (int i = 0; i < fields.size(); ++i) {
            field = fields.get(i);
            personal = new LowCodePersonal();
            personal.setUserId("default");
            personal.setMenuId(lowCode.getMenuId());
            personal.setTName(lowCode.getTName());
            personal.setShowFlag(field.getShowFlag());
            personal.setLabel(field.getLabel());
            personal.setProp(field.getProp());
            personal.setWidth(field.getWidth());
            personal.setHeaderAlign(field.getHeaderAlign());
            personal.setAlign(field.getAlign());
            personal.setFormatter(field.getFormatter());
            personal.setSortable(field.getSortable());
            personal.setSort(field.getSort());
            personal.setColType(field.getColType());
            personal.setExportFlag(field.getExportFlag());
            this.lowCodePersonalMapper.insert(personal);
        }
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    private List<LowCodePersonal> checkPersonal(LowCodePersonal lowCodePersonal, String userId, String menuId, String tName) {
        List<LowCodePersonal> list = this.lowCodePersonalMapper.selectByByUserIdMenuId("default", menuId, tName);
        if (lowCodePersonal.getUserId().equals("default")) {
            for (LowCodePersonal temp : list) {
                temp.setUserId(userId);
                this.lowCodePersonalMapper.insert(temp);
            }
        }
        return list;
    }
}

