-- drop table   SYS_DIC  ;
create table SYS_DIC
(
  id           VARCHAR2(32) not null,
  dic_code     VARCHAR2(50),
  dic_name     VARCHAR2(200),
  dic_type     VARCHAR2(200),
  sort         NUMBER(9),
  add_id       VARCHAR2(200),
  add_time     DATE,
  modify_id    VARCHAR2(200),
  modify_time  DATE,
  cancel_id    VARCHAR2(200),
  cancel_time  DATE,
  cancel_flag  VARCHAR2(1),
  belong_id    VARCHAR2(32),
  dic_value1   VARCHAR2(200),
  dic_value2   VARCHAR2(200),
  dic_value3   VARCHAR2(200),
  dic_classify VARCHAR2(200)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_DIC.cancel_flag
  is '0存在9不存在';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_DIC
  add constraint SYS_DIC_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
