package ${package.Controller};

import org.springframework.web.bind.annotation.RequestMapping;
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletRequest;

import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.ExceptionTools;
import com.shinsoft.tools.model.common.ResultJSON;
import com.shinsoft.tools.model.common.ResponseCodeMsg;

import ${package.Service}.${table.serviceName};

/**
 * <p>
 * ${table.comment!} 前端控制器
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
<#if restControllerStyle>
@RestController
<#else>
@Controller
</#if>
@RequestMapping("<#if package.ModuleName?? && package.ModuleName != "">/${package.ModuleName}</#if>/<#if controllerMappingHyphenStyle>${controllerMappingHyphen}<#else>${table.entityPath}</#if>")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public class ${table.controllerName} extends ${superControllerClass} {
<#else>
public class ${table.controllerName} {
</#if>



       @Autowired
       private ${table.serviceName} ${controllerMappingHyphen}Service;

       ResultJSON resultJSON;


       @RequestMapping(value = "/query")
       public ResultJSON query(int page, int rows, String params,  HttpServletRequest request) {
           try {
               String userId = (String) request.getHeader("userId");
               resultJSON = ${controllerMappingHyphen}Service.query(page, rows, params);
           } catch (Exception ex) {
               ex.printStackTrace();
               resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
           } finally {
               return resultJSON;
           }
       }

        @RequestMapping(value = "/queryByPK")
        public ResultJSON queryByPK(  String id,  HttpServletRequest request) {
            try {
                String userId = (String) request.getHeader("userId");
                resultJSON = ${controllerMappingHyphen}Service.queryByPK(id);
            } catch (Exception ex) {
                 ex.printStackTrace();
                 resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
            } finally {
                return resultJSON;
            }
        }

       @RequestMapping(value = "/save")
       public ResultJSON save(String json,  HttpServletRequest request) {
           try {
               String userId = (String) request.getHeader("userId");
               resultJSON = ${controllerMappingHyphen}Service.save(userId, json);
           } catch (Exception ex) {
               resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ExceptionTools.getExceptionAllinformation(ex));
               ex.printStackTrace();
           } finally {
               return resultJSON;
           }
       }

       @RequestMapping(value = "/remove")
       public ResultJSON remove(String id,   HttpServletRequest request) {
           try {
               String userId = (String) request.getHeader("userId");
               resultJSON = ${controllerMappingHyphen}Service.remove(userId, id);
           } catch (Exception ex) {
               ex.printStackTrace();
               resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
           } finally {
               return resultJSON;
           }
       }

 }
</#if>
