CREATE OR REPLACE PACKAGE BODY PKG_EXP IS
  /*******************************************************************************
  * PROGRAM HEADER  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  * -----------------------------------------------------------------------------
  * System Name      - 进销存
  * Sub_System Name  - 采购
  * Program Name     - BPUR_ORD_EXECU_RESULT
  * Creation Date    - 2020.11.09
  * Author           - 赵博
  * Description      - 采购执行情况查询
  ******************************************************************************/

  --************************************************************************
  --采购订单执行情况
  --************************************************************************
  PROCEDURE P_EXP_SELECT(P_MENU_ID IN VARCHAR2, RESULTS OUT V_CUR) IS
  BEGIN  
    open results for
      select d.menu_name, t.button_name
        from SYS_MENU_BUTTON t, sys_menu d
       where t.menu_id = d.id
         and d.menu_name like '%' || p_menu_id || '%'; 
  END P_EXP_SELECT;

  PROCEDURE P_EXP_SELECT_PAGE(P_MENU_ID IN VARCHAR2,
                              START_ROW IN NUMBER,
                              END_ROW   IN NUMBER,
                              TOTAL_ROW OUT NUMBER,
                              RESULTS   OUT V_CUR) IS
  BEGIN 
    select count(1)
      into TOTAL_ROW
      from SYS_MENU_BUTTON t, sys_menu d
     where t.menu_id = d.id
       and d.menu_name like '%' || p_menu_id || '%';
  
    open results for
      SELECT *
        FROM (SELECT TMP_PAGE.*, ROWNUM ROW_ID
                FROM (
                
                
                select d.menu_name, t.button_name
                        from SYS_MENU_BUTTON t, sys_menu d
                       where t.menu_id = d.id
                         and d.menu_name like '%' || P_MENU_ID || '%'
                         
                         
                         ) TMP_PAGE
               WHERE ROWNUM <= END_ROW)
       WHERE ROW_ID > START_ROW;
  
  END P_EXP_SELECT_PAGE;
  
  
  
  
  /*********正常*********/
  PROCEDURE P_EXP_COMMIT(P_param1 IN NUMBER,
                         P_param2 IN VARCHAR2,
                         P_param3 IN VARCHAR2,
                         code     OUT NUMBER,
                         RESULTS  OUT VARCHAR2) IS
  
  BEGIN
    code    := 0;
    RESULTS := '我是未报错：第一个参数：' || P_param1 || '；第二个参数：' || P_param2 ||
               '；第三个参数：' || P_param3;
  END P_EXP_COMMIT;
  /*********报错*********/
  PROCEDURE P_EXP_EXCEPTION(P_param1 IN NUMBER,
                           P_param2 IN VARCHAR2,
                           P_param3 IN VARCHAR2,
                           code     OUT NUMBER,
                           RESULTS  OUT VARCHAR2) IS
  
  BEGIN
    code    := 1;
    results := '我是报错信息：第一个参数：' || P_param1 || '；第二个参数：' || P_param2 ||
               '；第三个参数：' || P_param3;
  END P_EXP_EXCEPTION;

END PKG_EXP;
