<!--${cfg.moduleName}-->
<template>
    <div>
        <el-dialog title="请选择" :visible.sync="dialogVisible" width="800px" :close-on-click-modal="false"   v-dialogDrag >
            <el-card :body-style="cardBodyStyle">
                <el-form :model="query" label-position="right" label-width="80px" :inline="true">
                    <#list table.fields as field>
                        <#list cfg.querys as query>
                            <#if field.name == query.fieldName>
                                <#if query.controllerType == "日期">
                    <el-form-item label="${field.comment}">
                                    <#if query.dateFlag == '1'>
                        <el-date-picker v-model="query.${field.propertyName}" type="daterange" size="small" align="right" unlink-panels range-separator="至"
                                        start-placeholder="开始日期" end-placeholder="结束日期" :picker-options="pickerOptions" style="width: 250px;" value-format="yyyy-MM-dd">
                        </el-date-picker>
                                    <#else>
                        <el-date-picker v-model="query.${field.propertyName}" size="small" type="date" value-format="yyyy-MM-dd"
                                        style="width: 200px;"></el-date-picker>
                                    </#if>
                    </el-form-item>
                                <#elseif query.controllerType == "日期时间">
                    <el-form-item label="${field.comment}">
                                    <#if query.dateFlag == '1'>
                        <el-date-picker v-model="query.${field.propertyName}" type="datetimerange" size="small" align="right" unlink-panels range-separator="至"
                                        start-placeholder="开始日期" end-placeholder="结束日期" :picker-options="pickerOptions" style="width: 350px;" value-format="yyyy-MM-dd HH:mm:ss">
                        </el-date-picker>
                                    <#else>
                        <el-date-picker v-model="query.${field.propertyName}" size="small"  type="datetime" value-format="yyyy-MM-dd HH:mm:ss"
                                        style="width: 200px;"></el-date-picker>
                                    </#if>
                    </el-form-item>
                                <#else>
                    <el-form-item label="${field.comment}">
                        <el-input v-model="query.${field.propertyName}" size="small" clearable style="width: 200px;"></el-input>
                    </el-form-item>
                                </#if>
                            </#if>
                        </#list>
                    </#list>
                    <el-form-item label="">
                        <el-button type="primary" plain @click="handleSearch" size="small">查询</el-button>
                    </el-form-item>
                </el-form>
            </el-card>
            <el-card :body-style="cardBodyStyle">
                <el-table :data="tableData" border highlight-current-row v-loading="loading" >
                    <el-table-column type="index" label="序号" align="center" width="60" fixed>
                        <template slot-scope="scope">
                            <span>{{ scope.$index + (currentPage - 1) * pageSize + 1 }}</span>
                        </template>
                    </el-table-column>
                    <#if cfg.fixedFlag == '0'>
                        <el-table-column v-for="item in cols" :key="item.id" :prop="item.prop" :label="item.label" :width="item.width"
                                         show-overflow-tooltip :header-align="item.headerAlign" :align="item.align" :sortable="item.sortable=='true'"
                                         class-name="canDrag" :formatter="formatter">
                        </el-table-column>
                    <#else>
                        <#list table.fields as field>
                            <#list cfg.columns as column>
                                <#if field.name == column.fieldName>
                                    <el-table-column prop="${field.propertyName}" label="${field.comment}" width="${column.width}" header-align="center" align="${column.align}"
                                                     show-overflow-tooltip>
                                    </el-table-column>
                                </#if>
                            </#list>
                        </#list>
                    </#if>
                    <el-table-column label="操作" width="80" header-align="center" align="center" fixed="right">
                        <template slot-scope="scope">
                            <el-button size="mini" type="danger" @click="handleConfirm(scope.row)">选择</el-button>
                        </template>
                    </el-table-column>
                </el-table>
                <el-pagination :page-size="pageSize" @size-change="handleSizeChange" @current-change="handleCurrentChange"
                               :current-page="currentPage" background layout="total, sizes, prev, pager, next" :total="totalRows">
                </el-pagination>
            </el-card>
        </el-dialog>
    </div>
</template>

<script>
    import tools from '@/tools'
    import axios from '@/axios'
    export default {
        data() {
            return {
                <#if cfg.fixedFlag == '0'>
                cols: [],
                tName:'${cfg.tName}',
                </#if>
                dialogVisible: false,
                cardBodyStyle: tools.style.card,
                tableData: [],
                loading: false,
                currentPage: 1,
                totalRows: 0,
                pageSizes: [10, 20, 30, 40],
                pageSize: 10,
                dialogVisible: false,
                query: {
                    <#list table.fields as field>
                        <#list cfg.querys as query>
                            <#if field.name == query.fieldName>
                                <#if query.dateFlag == '1'>
                        ${field.propertyName}: ['',''],
                                    <#else>
                        ${field.propertyName}: '',
                                </#if>
                            </#if>
                        </#list>
                    </#list>
                 }<#noparse></#noparse>,
                pickerOptions: {
                    shortcuts: [{
                        text: '最近一周',
                        onClick(picker) {
                            const end = new Date();
                            const start = new Date();
                            start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
                            picker.$emit('pick', [start, end]);
                        }
                    }, {
                        text: '最近一个月',
                        onClick(picker) {
                            const end = new Date();
                            const start = new Date();
                            start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
                            picker.$emit('pick', [start, end]);
                        }
                    }, {
                        text: '最近三个月',
                        onClick(picker) {
                            const end = new Date();
                            const start = new Date();
                            start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
                            picker.$emit('pick', [start, end]);
                        }
                    }]
                },
            }
        },
        methods: {
            formatter(row, column, cellValue, index) {
                // if (column.property == '') {
                //     return ''
                // }
                return cellValue
            },
            handleSizeChange(val) {
                this.pageSize = val
                this.getTableData()
            },
            handleCurrentChange(val) {
                this.currentPage = val
                this.getTableData()
            },
            getTableData() {
                this.loading = true
                var url = '${cfg.moduleName}/${entity}/queryPopup.do'
                var param = {
                    page: this.currentPage,
                    rows: this.pageSize,
                    <#list table.fields as field>
                        <#list cfg.querys as query>
                            <#if field.name == query.fieldName>
                                <#if query.controllerType == "日期" || query.controllerType == "日期时间" >
                                    <#if query.dateFlag == '1'>
                        ${field.propertyName}Begin: date.getDateRangeBegin(this.query.${field.propertyName}),
                        ${field.propertyName}End: date.getDateRangeEnd(this.query.${field.propertyName}),
                                    <#else>
                        ${field.propertyName}Begin: date.getDateBegin(this.query.${field.propertyName}),
                        ${field.propertyName}End: date.getDateEnd(this.query.${field.propertyName}),
                                     </#if>
                                <#else>
                        ${field.propertyName}: this.query.${field.propertyName},
                                 </#if>
                             </#if>
                        </#list>
                    </#list>
                }
                axios.get(url, param).then(response => {
                    this.tableData = response.data.data.list
                    this.totalRows = response.data.data.total
                    this.loading = false
                });
            },
            handleSearch() {
                this.currentPage = 1
                this.getTableData()
            },
            show() {
                this.getCols()
                this.getTableData()
                this.dialogVisible = true
            },
            handleConfirm(row) {
                this.$emit('receiveFromChild', row);
                this.dialogVisible = false
            },
            <#if cfg.fixedFlag == '0'>
            getCols() {
                var url = 'framework/TablePersonal/queryByUserIdMenuId.do'
                var param = {
                    menuId: '${cfg.menuId}',
                    tName: this.tName
                }
                axios.get(url, param).then(response => {
                    var temp = [];
                    for (var col of response.data.data) {
                        if (col.showFlag == '1') {
                            temp.push(col)
                        }
                    }
                    var newArray = temp.slice(0);
                    this.cols = [];
                    this.$nextTick(() => {
                        this.cols = newArray;
                    });
                });
            },
            </#if>
        },
        // 父控件调用
        // <${entity?uncap_first}-popup ref="${entity}Popup" v-on:receiveFromChild="receiveFrom${entity}Popup"></${entity?uncap_first}-popup>,
        // import ${entity}Popup from './${entity}Popup.vue' //根据实际路径填写
        // components: {
        //   ${entity}Popup,
        // },
        // handlePopup() {
        //   this.$refs.${entity}Popup.show()
        // },
        // receiveFrom${entity}Popup(row) {
        //   console.com.shinsoft.log(JSON.stringify(row))
        // },

    }
</script>

<style>
</style>
