/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.workflowapi.util;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.shinsoft.workflowapi.model.WorkModel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FlowModelUtil {
    public static <T> List<T> bizEnhanceFlows(List<T> businessEntities) {
        ArrayList<T> result = new ArrayList<T>();
        for (T entity : businessEntities) {
            try {
                Class<?> entityClass = entity.getClass();
                Field workIdField = entityClass.getDeclaredField("workId");
                workIdField.setAccessible(true);
                String workId = (String)workIdField.get(entity);
                Field trackIdField = entityClass.getDeclaredField("trackId");
                trackIdField.setAccessible(true);
                String trackId = (String)trackIdField.get(entity);
                WorkModel workModel = new WorkModel();
                if (workId != null && !workId.isEmpty()) {
                    workModel = FlowModelUtil.generateWorkModel(workId, trackId);
                }
                Method setWorkModelMethod = entity.getClass().getMethod("setWorkModel", WorkModel.class);
                setWorkModelMethod.invoke(entity, workModel);
                result.add(entity);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkModel generateWorkModel(String workId, String trackId) {
        WorkModel workModel = new WorkModel();
        if (workId == null || trackId == null) {
            return workModel;
        }
        try {
            String token = FlowModelUtil.getNewToken("admin", "1234");
            if (token == null || token.isEmpty()) {
                WorkModel workModel2 = workModel;
                return workModel2;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("accessToken", (Object)token);
            jsonObject.put("workId", (Object)workId);
            jsonObject.put("trackId", (Object)trackId);
            String re = HttpRequest.post((String)"http://10.198.1.29:8080/horizon-workflow-boot/horizon/workflow/rest/flow/support/open.wf").contentType("application/json").body(jsonObject.toJSONString()).execute().body();
            Map data = (Map)JSONObject.parseObject((String)re, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            if (data.get("flowId") != null && data.get("flowStatus") != null) {
                workModel.setFlowId(data.get("flowId").toString());
                workModel.setFlowName(data.get("flowName").toString());
                workModel.setWorkId(workId);
                workModel.setTrackId(trackId);
                workModel.setFlowStatus(data.get("flowStatus").toString());
                workModel.setFlowStatusName(data.get("flowStatusName").toString());
                workModel.setFlowNode(((Map)JSONObject.parseObject((String)data.get("flowNode").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])).get("nodeName").toString());
                String nodeId = ((Map)JSONObject.parseObject((String)data.get("flowNode").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])).get("nodeId").toString();
                String initiateUserId = ((Map)JSONObject.parseObject((String)data.get("flowUser").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])).get("userId").toString();
                workModel.setInitiateUserId(initiateUserId);
                if (nodeId.equals("Node1")) {
                    workModel.setOpType("1");
                } else {
                    workModel.setOpType("0");
                }
            }
            JSONObject action = new JSONObject();
            action.put("operate", (Object)"close");
            action.put("reOpen", (Object)"false");
            jsonObject.put("actionData", (Object)action);
            HttpRequest.post((String)"http://10.198.1.29:8080/horizon-workflow-boot/horizon/workflow/rest/flow/support/action.wf").contentType("application/json").body(jsonObject.toJSONString()).execute().body();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            return workModel;
        }
    }

    public static String getNewToken(String loginName, String password) {
        String token = "";
        String url = "http://10.198.1.29:8080/horizon-workflow-boot/horizon/workflow/rest/user/login.wf";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("loginName", (Object)loginName);
        jsonObject.put("password", (Object)password);
        String re = HttpRequest.post((String)url).contentType("application/json").body(jsonObject.toJSONString()).execute().body();
        System.out.println(re);
        JSONObject jsonRe = JSONObject.parseObject((String)re);
        if (jsonRe.getString("code").equals("0")) {
            token = jsonRe.getJSONObject("data").getString("accessToken");
        }
        return token;
    }
}

