/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class QRCodeTools {
    private static final int QRCOLOR = -16777216;
    private static final int BGWHITE = -1;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 400;
    private static Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            this.put(EncodeHintType.CHARACTER_SET, "utf-8");
            this.put(EncodeHintType.MARGIN, 0);
        }
    };
    private static final int IMAGE_WIDTH = 80;
    private static final int IMAGE_HEIGHT = 80;
    private static final int IMAGE_HALF_WIDTH = 40;
    private static final int FRAME_WIDTH = 2;
    private static MultiFormatWriter mutiWriter = new MultiFormatWriter();

    public static void drawLogoQRCode(File logoFile, File codeFile, String qrUrl, String note) {
        try {
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bm = multiFormatWriter.encode(qrUrl, BarcodeFormat.QR_CODE, 400, 400, hints);
            BufferedImage image = new BufferedImage(400, 400, 1);
            for (int x = 0; x < 400; ++x) {
                for (int y = 0; y < 400; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
            int width = image.getWidth();
            int height = image.getHeight();
            if (logoFile.exists()) {
                Graphics2D g = image.createGraphics();
                BufferedImage logo = ImageIO.read(logoFile);
                g.drawImage(logo, width * 2 / 5, height * 2 / 5, width * 2 / 10, height * 2 / 10, null);
                g.dispose();
                logo.flush();
            }
            if (StringUtils.isNotEmpty((CharSequence)note)) {
                BufferedImage outImage = new BufferedImage(400, 445, 6);
                Graphics2D outg = outImage.createGraphics();
                outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                outg.setColor(Color.BLACK);
                outg.setFont(new Font("\u6977\u4f53", 1, 30));
                int strWidth = outg.getFontMetrics().stringWidth(note);
                if (strWidth > 399) {
                    String note1 = note.substring(0, note.length() / 2);
                    String note2 = note.substring(note.length() / 2, note.length());
                    int strWidth1 = outg.getFontMetrics().stringWidth(note1);
                    int strWidth2 = outg.getFontMetrics().stringWidth(note2);
                    outg.drawString(note1, 200 - strWidth1 / 2, height + (outImage.getHeight() - height) / 2 + 12);
                    BufferedImage outImage2 = new BufferedImage(400, 485, 6);
                    Graphics2D outg2 = outImage2.createGraphics();
                    outg2.drawImage(outImage, 0, 0, outImage.getWidth(), outImage.getHeight(), null);
                    outg2.setColor(Color.BLACK);
                    outg2.setFont(new Font("\u5b8b\u4f53", 1, 30));
                    outg2.drawString(note2, 200 - strWidth2 / 2, outImage.getHeight() + (outImage2.getHeight() - outImage.getHeight()) / 2 + 5);
                    outg2.dispose();
                    outImage2.flush();
                    outImage = outImage2;
                } else {
                    outg.drawString(note, 200 - strWidth / 2, height + (outImage.getHeight() - height) / 2 + 12);
                }
                outg.dispose();
                outImage.flush();
                image = outImage;
            }
            image.flush();
            ImageIO.write((RenderedImage)image, "png", codeFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getQRCodeWithLogo(String logoPath, String outPath, String content, String note) {
        File logoFile = null;
        File codeFile = null;
        try {
            logoFile = new File(logoPath);
            codeFile = new File(outPath);
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bm = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
            BufferedImage image = new BufferedImage(400, 400, 1);
            for (int x = 0; x < 400; ++x) {
                for (int y = 0; y < 400; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
            int width = image.getWidth();
            int height = image.getHeight();
            if (logoFile.exists()) {
                Graphics2D g = image.createGraphics();
                BufferedImage logo = ImageIO.read(logoFile);
                g.drawImage(logo, width / 2 - width / 16, height / 2 - height / 16, width / 8, height / 8, null);
                g.dispose();
                logo.flush();
            }
            if (StringUtils.isNotEmpty((CharSequence)note)) {
                BufferedImage outImage = new BufferedImage(400, 445, 6);
                Graphics2D outg = outImage.createGraphics();
                outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                outg.setColor(Color.BLACK);
                outg.setFont(new Font("\u6977\u4f53", 1, 30));
                int strWidth = outg.getFontMetrics().stringWidth(note);
                if (strWidth > 399) {
                    String note1 = note.substring(0, note.length() / 2);
                    String note2 = note.substring(note.length() / 2, note.length());
                    int strWidth1 = outg.getFontMetrics().stringWidth(note1);
                    int strWidth2 = outg.getFontMetrics().stringWidth(note2);
                    outg.drawString(note1, 200 - strWidth1 / 2, height + (outImage.getHeight() - height) / 2 + 12);
                    BufferedImage outImage2 = new BufferedImage(400, 485, 6);
                    Graphics2D outg2 = outImage2.createGraphics();
                    outg2.drawImage(outImage, 0, 0, outImage.getWidth(), outImage.getHeight(), null);
                    outg2.setColor(Color.BLACK);
                    outg2.setFont(new Font("\u5b8b\u4f53", 1, 30));
                    outg2.drawString(note2, 200 - strWidth2 / 2, outImage.getHeight() + (outImage2.getHeight() - outImage.getHeight()) / 2 + 5);
                    outg2.dispose();
                    outImage2.flush();
                    outImage = outImage2;
                } else {
                    outg.drawString(note, 200 - strWidth / 2, height + (outImage.getHeight() - height) / 2 + 12);
                }
                outg.dispose();
                outImage.flush();
                image = outImage;
            }
            image.flush();
            ImageIO.write((RenderedImage)image, "png", codeFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image getQRCodeWithLogoReturnImage(String logoPath, String content, String note) {
        File logoFile = null;
        Object codeFile = null;
        try {
            logoFile = new File(logoPath);
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bm = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
            BufferedImage image = new BufferedImage(400, 400, 1);
            for (int x = 0; x < 400; ++x) {
                for (int y = 0; y < 400; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
            int width = image.getWidth();
            int height = image.getHeight();
            if (logoFile.exists()) {
                Graphics2D g = image.createGraphics();
                BufferedImage logo = ImageIO.read(logoFile);
                g.drawImage(logo, width / 2 - width / 16, height / 2 - height / 16, width / 8, height / 8, null);
                g.dispose();
                logo.flush();
            }
            if (StringUtils.isNotEmpty((CharSequence)note)) {
                BufferedImage outImage = new BufferedImage(400, 445, 6);
                Graphics2D outg = outImage.createGraphics();
                outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                outg.setColor(Color.BLACK);
                outg.setFont(new Font("\u6977\u4f53", 1, 30));
                int strWidth = outg.getFontMetrics().stringWidth(note);
                if (strWidth > 399) {
                    String note1 = note.substring(0, note.length() / 2);
                    String note2 = note.substring(note.length() / 2, note.length());
                    int strWidth1 = outg.getFontMetrics().stringWidth(note1);
                    int strWidth2 = outg.getFontMetrics().stringWidth(note2);
                    outg.drawString(note1, 200 - strWidth1 / 2, height + (outImage.getHeight() - height) / 2 + 12);
                    BufferedImage outImage2 = new BufferedImage(400, 485, 6);
                    Graphics2D outg2 = outImage2.createGraphics();
                    outg2.drawImage(outImage, 0, 0, outImage.getWidth(), outImage.getHeight(), null);
                    outg2.setColor(Color.BLACK);
                    outg2.setFont(new Font("\u5b8b\u4f53", 1, 30));
                    outg2.drawString(note2, 200 - strWidth2 / 2, outImage.getHeight() + (outImage2.getHeight() - outImage.getHeight()) / 2 + 5);
                    outg2.dispose();
                    outImage2.flush();
                    outImage = outImage2;
                } else {
                    outg.drawString(note, 200 - strWidth / 2, height + (outImage.getHeight() - height) / 2 + 12);
                }
                outg.dispose();
                outImage.flush();
                image = outImage;
            }
            image.flush();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void encode(String content, int width, int height, String srcImagePath, String destImagePath) {
        try {
            ImageIO.write((RenderedImage)QRCodeTools.genBarcode(content, width, height, srcImagePath), "jpg", new File(destImagePath));
            System.out.println("\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f\uff01");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
    }

    private static BufferedImage genBarcode(String content, int width, int height, String srcImagePath) throws WriterException, IOException {
        BufferedImage scaleImage = QRCodeTools.scale(srcImagePath, 80, 80, true);
        int[][] srcPixels = new int[80][80];
        for (int i = 0; i < scaleImage.getWidth(); ++i) {
            for (int j = 0; j < scaleImage.getHeight(); ++j) {
                srcPixels[i][j] = scaleImage.getRGB(i, j);
            }
        }
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, (String)ErrorCorrectionLevel.H);
        BitMatrix matrix = mutiWriter.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        int halfW = matrix.getWidth() / 2;
        int halfH = matrix.getHeight() / 2;
        int[] pixels = new int[width * height];
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                if (x > halfW - 40 && x < halfW + 40 && y > halfH - 40 && y < halfH + 40) {
                    pixels[y * width + x] = srcPixels[x - halfW + 40][y - halfH + 40];
                    continue;
                }
                if (x > halfW - 40 - 2 && x < halfW - 40 + 2 && y > halfH - 40 - 2 && y < halfH + 40 + 2 || x > halfW + 40 - 2 && x < halfW + 40 + 2 && y > halfH - 40 - 2 && y < halfH + 40 + 2 || x > halfW - 40 - 2 && x < halfW + 40 + 2 && y > halfH - 40 - 2 && y < halfH - 40 + 2 || x > halfW - 40 - 2 && x < halfW + 40 + 2 && y > halfH + 40 - 2 && y < halfH + 40 + 2) {
                    pixels[y * width + x] = 0xFFFFFFF;
                    continue;
                }
                int num1 = (int)(50.0 - 37.0 / (double)matrix.getHeight() * (double)(y + 1));
                int num2 = (int)(165.0 - 93.0 / (double)matrix.getHeight() * (double)(y + 1));
                int num3 = (int)(162.0 - 55.0 / (double)matrix.getHeight() * (double)(y + 1));
                Color color = Color.black;
                int colorInt = color.getRGB();
                pixels[y * width + x] = matrix.get(x, y) ? colorInt : 0xFFFFFF;
            }
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        image.getRaster().setDataElements(0, 0, width, height, pixels);
        return image;
    }

    private static BufferedImage scale(String srcImageFile, int height, int width, boolean hasFiller) throws IOException {
        double ratio = 0.0;
        File file = new File(srcImageFile);
        BufferedImage srcImage = ImageIO.read(file);
        Image destImage = srcImage.getScaledInstance(width, height, 4);
        if (srcImage.getHeight() > height || srcImage.getWidth() > width) {
            ratio = srcImage.getHeight() > srcImage.getWidth() ? new Integer(height).doubleValue() / (double)srcImage.getHeight() : new Integer(width).doubleValue() / (double)srcImage.getWidth();
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
            destImage = op.filter(srcImage, null);
        }
        if (hasFiller) {
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D graphic = image.createGraphics();
            graphic.setColor(Color.white);
            graphic.fillRect(0, 0, width, height);
            if (width == destImage.getWidth(null)) {
                graphic.drawImage(destImage, 0, (height - destImage.getHeight(null)) / 2, destImage.getWidth(null), destImage.getHeight(null), Color.white, null);
            } else {
                graphic.drawImage(destImage, (width - destImage.getWidth(null)) / 2, 0, destImage.getWidth(null), destImage.getHeight(null), Color.white, null);
            }
            graphic.dispose();
            destImage = image;
        }
        return (BufferedImage)destImage;
    }
}

