/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpClientTools {
    private static final CloseableHttpClient httpClient;
    public static final String CHARSET = "UTF-8";

    public static String doGet(String url, Map<String, String> params) {
        return HttpClientTools.doGet(url, params, CHARSET);
    }

    public static String doGetSSL(String url, Map<String, String> params) {
        return HttpClientTools.doGetSSL(url, params, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params) throws IOException {
        return HttpClientTools.doPost(url, params, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            HttpGet httpGet;
            CloseableHttpResponse response;
            int statusCode;
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            if ((statusCode = (response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(url)))).getStatusLine().getStatusCode()) != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, String charset) throws IOException {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        ArrayList<BasicNameValuePair> pairs = null;
        if (params != null && !params.isEmpty()) {
            pairs = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        HttpPost httpPost = new HttpPost(url);
        if (pairs != null && pairs.size() > 0) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
        }
        try (CloseableHttpResponse response = null;){
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        return null;
    }

    public static String doGetSSL(String url, Map<String, String> params, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpClient httpsClient = HttpClientTools.createSSLClientDefault();
            CloseableHttpResponse response = httpsClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }

    static {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }
}

