/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools.ExcelTools;

import cn.hutool.core.util.NumberUtil;
import com.shinsoft.tools.ClassTool;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.springframework.util.StringUtils;

public class ExportExcelTools<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getExportOutStream(String filename, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes("UTF-8"), "ISO8859-1"));
            out = response.getOutputStream();
            return out;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            return out;
        }
    }

    public static <T> List<Map<String, Object>> getExportData(String[] arrKey, List<T> list) {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < arrKey.length; ++j) {
                map.put(arrKey[j], ClassTool.getFieldValueByFieldName(arrKey[j], list.get(i)));
            }
            listmap.add(map);
        }
        return listmap;
    }

    public static <T> List<Map<String, Object>> getExportData(List<String> cols, List<T> list) {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < cols.size(); ++j) {
                map.put(cols.get(j), ClassTool.getFieldValueByFieldName(cols.get(j), list.get(i)));
            }
            listmap.add(map);
        }
        return listmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportHSExcelByColumn(String title, String[] headers, String[] columns, Collection<T> dataset, OutputStream out, String pattern) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        sheet.setDefaultRowHeightInPoints(24.0f);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        CellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font2 = workbook.createFont();
        font.setBold(true);
        style2.setFont(font2);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Comment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new HSSFRichTextString("Created By Phil"));
        comment.setAuthor("phil");
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(style);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "yyyy/MM/dd";
        }
        FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
        Iterator<T> it = dataset.iterator();
        int index = 0;
        int count = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            count = headers.length < columns.length ? headers.length : columns.length;
            for (int i = 0; i < count; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(style2);
                String fieldName = columns[i];
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        textValue = instance.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, 2856);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(bsValue, 5));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    HSSFRichTextString richString = new HSSFRichTextString(textValue);
                    Font font3 = workbook.createFont();
                    font3.setColor(IndexedColors.BLACK.index);
                    richString.applyFont(font3);
                    cell.setCellValue((RichTextString)richString);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXSExcelByColumn(String title, List<String> headers, List<String> columns, List<Integer> arrWidth, Collection<Map<String, Object>> dataset, OutputStream out, String pattern) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(10);
        sheet.setDefaultRowHeightInPoints(24.0f);
        XSSFPrintSetup ps = (XSSFPrintSetup)sheet.getPrintSetup();
        ps.setLandscape(true);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        style.setFont(font);
        CellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font2 = workbook.createFont();
        font.setBold(true);
        style2.setFont(font2);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Comment comment = patriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new XSSFRichTextString("Created By Phil"));
        comment.setAuthor("phil");
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(style);
            XSSFRichTextString text = new XSSFRichTextString(headers.get(i));
            cell.setCellValue((RichTextString)text);
        }
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "yyyy/MM/dd";
        }
        FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
        Iterator<Map<String, Object>> it = dataset.iterator();
        int index = 0;
        int count = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Map<String, Object> map = it.next();
            count = headers.size() < columns.size() ? headers.size() : columns.size();
            for (int i = 0; i < count; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(style2);
                try {
                    Object value = map.get(columns.get(i));
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        textValue = instance.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, arrWidth.get(i).intValue());
                        byte[] bsValue = (byte[])value;
                        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(bsValue, 5));
                    } else if (i == 0) {
                        textValue = index + "";
                        sheet.setColumnWidth(i, (int)((double)arrWidth.get(i).intValue() * 37.5));
                    } else if (value != null) {
                        textValue = value.toString();
                        sheet.setColumnWidth(i, (int)((double)arrWidth.get(i).intValue() * 37.5));
                    } else {
                        textValue = "";
                    }
                    if (textValue == null) continue;
                    if (NumberUtil.isNumber((CharSequence)textValue)) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    XSSFRichTextString richString = new XSSFRichTextString(textValue);
                    Font fontContent = workbook.createFont();
                    fontContent.setColor(IndexedColors.BLACK.index);
                    richString.applyFont(fontContent);
                    cell.setCellValue((RichTextString)richString);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXSExcelByColumn(String title, String[] headers, String[] columns, int[] arrWidth, Collection<Map<String, Object>> dataset, OutputStream out, String pattern) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(10);
        sheet.setDefaultRowHeightInPoints(24.0f);
        XSSFPrintSetup ps = (XSSFPrintSetup)sheet.getPrintSetup();
        ps.setLandscape(true);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        style.setFont(font);
        CellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font2 = workbook.createFont();
        font.setBold(true);
        style2.setFont(font2);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Comment comment = patriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new XSSFRichTextString("Created By Phil"));
        comment.setAuthor("phil");
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(style);
            XSSFRichTextString text = new XSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "yyyy/MM/dd";
        }
        FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
        Iterator<Map<String, Object>> it = dataset.iterator();
        int index = 0;
        int count = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Map<String, Object> map = it.next();
            count = headers.length < columns.length ? headers.length : columns.length;
            for (int i = 0; i < count; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(style2);
                try {
                    Object value = map.get(columns[i]);
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        textValue = instance.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, arrWidth[i]);
                        byte[] bsValue = (byte[])value;
                        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(bsValue, 5));
                    } else if (i == 0) {
                        textValue = index + "";
                        sheet.setColumnWidth(i, (int)((double)arrWidth[i] * 37.5));
                    } else if (value != null) {
                        textValue = value.toString();
                        sheet.setColumnWidth(i, (int)((double)arrWidth[i] * 37.5));
                    } else {
                        textValue = "";
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    XSSFRichTextString richString = new XSSFRichTextString(textValue);
                    Font font3 = workbook.createFont();
                    font3.setColor(IndexedColors.BLACK.index);
                    richString.applyFont(font3);
                    cell.setCellValue((RichTextString)richString);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

