/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Decoder;

public class AESTools {
    private static String AES_KEY = "1234567890ABCDEF";
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";
    private static String iv = "1234567890ABCDEF";
    private static String Algorithm = "AES";
    private static String AlgorithmProvider = "AES/CBC/PKCS5Padding";

    public static String decryptECS(String encrypt) {
        try {
            return AESTools.aesDecrypt(encrypt, AES_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String encryptECS(String content) {
        try {
            return AESTools.aesEncrypt(content, AES_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtils.isEmpty((CharSequence)base64Code) ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes("utf-8"));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return AESTools.base64Encode(AESTools.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AESTools.aesDecryptByBytes(AESTools.base64Decode(encryptStr), decryptKey);
    }

    public static byte[] generatorKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(Algorithm);
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static IvParameterSpec getIv() throws UnsupportedEncodingException {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes("utf-8"));
        return ivParameterSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptCBC(String src) {
        String result = "";
        try {
            byte[] key = AES_KEY.getBytes("utf-8");
            SecretKeySpec secretKey = new SecretKeySpec(key, Algorithm);
            IvParameterSpec ivParameterSpec = AESTools.getIv();
            Cipher cipher = Cipher.getInstance(AlgorithmProvider);
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            byte[] cipherBytes = cipher.doFinal(src.getBytes(Charset.forName("utf-8")));
            result = AESTools.byteToHexString(cipherBytes);
            return result;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptCBC(String src) {
        String result = "";
        try {
            byte[] key = AES_KEY.getBytes("utf-8");
            SecretKeySpec secretKey = new SecretKeySpec(key, Algorithm);
            IvParameterSpec ivParameterSpec = AESTools.getIv();
            Cipher cipher = Cipher.getInstance(AlgorithmProvider);
            cipher.init(2, (Key)secretKey, ivParameterSpec);
            byte[] hexBytes = AESTools.hexStringToBytes(src);
            byte[] plainBytes = cipher.doFinal(hexBytes);
            result = new String(plainBytes, "utf-8");
            return result;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    public static String byteToHexString(byte[] src) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                sb.append("0");
            }
            sb.append(hv);
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            b[i] = (byte)(AESTools.charToByte(hexChars[pos]) << 4 | AESTools.charToByte(hexChars[pos + 1]));
        }
        return b;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static void main(String[] args) {
        String src = "ba998b6b775d7a396023200e6f0bb4e938dd4ded204f35aca8050abfc53c2b94e0e794e0e5fb35e8a5acbfdf918bde8835da320c12b81a2d942ff3075a58ca43001e15d675dacb2faf6343b18e02b006c2571b12814d41893cd5c10b068584204ce7f2f6c25fb273e66db4107328c5f023f28966dc828cff5916273dfa446e8f4a8ba517f9e33fcdb133a020b8a0ed9f4602d705159f733f8232a9dd8e4ddc4d7c659c1fa6912f62fbc08a4ab11c49db1883889cf574b7624896d32f21897acfba6e48e41bc34ce088640de292168b202fe725e4ba19769fb614834a1b9d7fb82f27359e5b5f79d685e721cd9564813c84f08091ea37a0438c4e49b1675dab63d0d0361eeb341744949db1d85e3df63b15543a960a375dc5967db0f9490dae42c79f156d545c50201ffa62cea3633b7c355783b9cbfecd411b0e8105758303815350b47edf7cb887eb6bcd3327948f930e1a133cf4cf5ade708bd3443a7228e0fbf37b84fb790a36da51ad658a5e0e72e3ca11a882759d958c2d7baa7b63caf836d66cfbd8dacf7b94a1bdc913d21db2539037f385c2144e1c65f39bde4de0316a65dcf4e61afaea07238062a490aabb7dce47d10d9c03167ceaed2801b9ba4f959652794ee093a84ef81c08e9483c2e648bbe116958bb22f412f2f71e591b5fd10cb0de13aeda2fc17af0d8f7873959ffae08805fa0ccd487fa17106585dffb159734ed1981458a2d7201781dcc04eaf963be0961c2892b4c760b870a5e4df058f919e6d9f3d0f12c14d83c02fc117ddb68e68cfed6d1075ed3b5671ac1716ba0a0036f5b4ff7b45c350a9a460dc688300aa269cc5b4686bc27968ee0001fc90a4717a115c3089568963751077865c849d9e543deb27055d432964e730f624b72b166c2efc82143abe58f56f381cb67c702e29fab1b9fb53818a385ac4582d04ce94204e906325eb16a7200677c52bd550e145d758cd85a66323bf6bfec8da498e7092edcf0512975ae1e0f87c9b2742dd4833faa526250cd18904eff0aff18b0133e3594847225253e7a19c48018ff458c2aeb033492c09ae96a8789ed1395e94f5f470f3c25b73e8337d1e61c6c403878754fc68db15fc677f46c4d2f60cb95397190bd4dbfaabad4d2c2817e290e31928a03dba8aa78d9544acba788e49c";
        System.out.println("\u89e3\u5bc6\uff1a" + AESTools.decryptCBC(src));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptCBC(String src, String aesKey, String aesIv) {
        String result = "";
        try {
            byte[] key = aesKey.getBytes("utf-8");
            SecretKeySpec secretKey = new SecretKeySpec(key, Algorithm);
            IvParameterSpec ivParameterSpec = AESTools.getIv(aesIv);
            Cipher cipher = Cipher.getInstance(AlgorithmProvider);
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            byte[] cipherBytes = cipher.doFinal(src.getBytes(Charset.forName("utf-8")));
            result = AESTools.byteToHexString(cipherBytes);
            return result;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptCBC(String src, String aesKey, String aesIv) {
        String result = "";
        try {
            byte[] key = aesKey.getBytes("utf-8");
            SecretKeySpec secretKey = new SecretKeySpec(key, Algorithm);
            IvParameterSpec ivParameterSpec = AESTools.getIv(aesIv);
            Cipher cipher = Cipher.getInstance(AlgorithmProvider);
            cipher.init(2, (Key)secretKey, ivParameterSpec);
            byte[] hexBytes = AESTools.hexStringToBytes(src);
            byte[] plainBytes = cipher.doFinal(hexBytes);
            result = new String(plainBytes, "utf-8");
            return result;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    public static IvParameterSpec getIv(String aesIv) throws UnsupportedEncodingException {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(aesIv.getBytes("utf-8"));
        return ivParameterSpec;
    }
}

