package ${package.ServiceImpl};

import ${package.Entity}.${entity};
import ${package.Mapper}.${table.mapperName};
<#if table.serviceInterface>
    import ${package.Service}.${table.serviceName};
</#if>
import ${superServiceImplClassPackage};
import org.springframework.stereotype.Service;


import org.springframework.beans.factory.annotation.Autowired;
import java.util.Date;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResultJSON;
import org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;


/**
* <p>
    * ${table.comment!} 服务实现类
    * </p>
*
* @author ${author}
* @since ${date}
*/
@Service
<#if kotlin>
    open class ${table.serviceImplName} : ${superServiceImplClass}<${table.mapperName}, ${entity}>()<#if table.serviceInterface>, ${table.serviceName}</#if> {

    }
<#else>
    public class ${table.serviceImplName} extends ${superServiceImplClass}<${table.mapperName}, ${entity}><#if table.serviceInterface> implements ${table.serviceName}</#if> {


    ResultJSON resultJSON;

    @Autowired
    ${table.mapperName} ${controllerMappingHyphen}Mapper;

    @Override
    public ResultJSON query(int page,int rows,String params){
    JSONObject jsonObject=JSON.parseObject(params);
    <#list queryList as item>
        <#if item.fieldType == 'varchar'||item.fieldType == 'VARCHAR2'>
            String ${item.prop} = jsonObject.getString("${item.prop}");
        <#elseif item.fieldType == 'int'||item.fieldType == 'int'>
            int ${item.prop} = jsonObject.getInteger("${item.prop}");
        <#elseif item.fieldType == 'double'||item.fieldType == 'double'>
            Double ${item.prop} = jsonObject.getDouble("${item.prop}");
        <#elseif item.fieldType == 'NUMBER'&& item.dataPrecision == 0>
            int ${item.prop} = jsonObject.getInteger("${item.prop}");
        <#elseif item.fieldType == 'NUMBER'&& item.dataPrecision != 0>
            Double ${item.prop} = jsonObject.getDouble("${item.prop}");
        <#elseif item.fieldType == 'date'||item.fieldType == 'datetime'||item.fieldType == 'DATE'>
            <#if item.dateFlag=='1'>
                JSONArray ${item.prop}Range = jsonObject.getJSONArray("${item.prop}");
                Date ${item.prop}Begin = ${item.prop}Range.getDate(0);
                Date ${item.prop}End = ${item.prop}Range.getDate(1);
            <#else>
                Date ${item.prop} = jsonObject.getDate("${item.prop}");
            </#if>
        </#if>
    </#list>
    Page<${entity}> ${controllerMappingHyphen}Page=new Page<>(page,rows);
    QueryWrapper<${entity}>queryWrapper=new QueryWrapper<>();
    <#list queryList as item>
         <#if item.fieldType == 'date'||item.fieldType == 'datetime'||item.fieldType == 'DATE'>
             <#if item.dateFlag=='1'>
                 queryWrapper.between("${item.fieldName}",${item.prop}Begin, ${item.prop}End);
             <#else>
                 queryWrapper.eq("${item.fieldName}",${item.prop});
             </#if>
         <#else>
            <#if item.fuzzyFlag == '1'>
                queryWrapper.like("${item.fieldName}",${item.prop});
            <#else>
                queryWrapper.eq("${item.fieldName}",${item.prop});
            </#if>
         </#if>
    </#list>
    queryWrapper.orderByDesc("add_time");
    IPage<${entity}>list= ${controllerMappingHyphen}Mapper.selectPage(${controllerMappingHyphen}Page,queryWrapper);
    resultJSON=JSONTools.toResultJSON(list);
    return resultJSON;
    }

    @Override
    public ResultJSON queryByPK(String id) {
        ${entity} ${controllerMappingHyphen} =  ${controllerMappingHyphen}Mapper.selectByPK(id);
        resultJSON = JSONTools.toResultJSON(${controllerMappingHyphen});
        return resultJSON;
    }


    @Override
    public ResultJSON save(String userId,String json){
    ${entity} ${controllerMappingHyphen} =JSON.parseObject(json,new TypeReference<${entity}>(){
    });
    if(StringUtils.isEmpty(${controllerMappingHyphen}.getId())){
    //${controllerMappingHyphen}.setCancelFlag("0");
    ${controllerMappingHyphen}.setAddId(userId);
    //${controllerMappingHyphen}.setAddTime(date);
    ${controllerMappingHyphen}Mapper.insert(${controllerMappingHyphen});
    }else{
    ${controllerMappingHyphen}.setModifyId(userId);
    //${controllerMappingHyphen}.setModifyTime(date);
    ${controllerMappingHyphen}Mapper.updateById(${controllerMappingHyphen});
    }

    resultJSON=JSONTools.toResultJSON(${controllerMappingHyphen});
    return resultJSON;
    }

    @Override
    public ResultJSON remove(String userId,String id){
    Date date=new Date();
    ${entity} ${controllerMappingHyphen} = ${controllerMappingHyphen}Mapper.selectById(id);
    //${controllerMappingHyphen}.setCancelFlag("1");
    ${controllerMappingHyphen}.setCancelId(userId);
    ${controllerMappingHyphen}.setCancelTime(date);
    ${controllerMappingHyphen}Mapper.updateById(${controllerMappingHyphen});
    ${controllerMappingHyphen}Mapper.deleteById(${controllerMappingHyphen});
    resultJSON=JSONTools.toResultJSON("");
    return resultJSON;
    }



    }
</#if>
