-- drop table   SYS_LOG  ;
create table SYS_LOG
(
  id           VARCHAR2(200) not null,
  log_ip       VARCHAR2(200),
  log_hostname VARCHAR2(200),
  log_type     VARCHAR2(50),
  log_info     VARCHAR2(500),
  add_id       VARCHAR2(32),
  add_time     DATE,
  class_name   VARCHAR2(200),
  method_name  VARCHAR2(200),
  belong_id    VARCHAR2(32),
  port         VARCHAR2(10),
  log_data     BLOB
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_LOG
  add constraint SYS_LOG_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
