-- Create table
create table SYS_APP_VERSION
(
name                    VARCHAR2(32),
code                    NUMBER(9),
detail                  VARCHAR2(200),
memo                    VARCHAR2(500),
use_flag                VARCHAR2(1),
id                      VARCHAR2(32) not null,
process_instance_id     VARCHAR2(32),
process_instance_status VARCHAR2(50),
add_id                  VARCHAR2(32),
add_code                VARCHAR2(50),
add_name                VARCHAR2(50),
add_dept_code           VARCHAR2(50),
add_dept_name           VARCHAR2(50),
add_time                DATE,
modify_id               VARCHAR2(32),
modify_code             VARCHAR2(50),
modify_name             VARCHAR2(50),
modify_time             DATE,
cancel_id               VARCHAR2(32),
cancel_code             VARCHAR2(50),
cancel_name             VARCHAR2(50),
cancel_time             DATE,
cancel_flag             VARCHAR2(50),
belong_id               VARCHAR2(32)
)
tablespace ${tableSpace}
pctfree 10
initrans 1
maxtrans 255
storage
(
initial 16K
next 8K
minextents 1
maxextents unlimited
);
-- Add comments to the columns
comment on column SYS_APP_VERSION.name
is '版本名';
comment on column SYS_APP_VERSION.code
is '版本号';
comment on column SYS_APP_VERSION.detail
is '更新内容';
comment on column SYS_APP_VERSION.memo
is '备注';
comment on column SYS_APP_VERSION.use_flag
is '启用标志';
comment on column SYS_APP_VERSION.id
is '主键';
comment on column SYS_APP_VERSION.process_instance_id
is '流程id';
comment on column SYS_APP_VERSION.process_instance_status
is '流程状态';
comment on column SYS_APP_VERSION.add_id
is '添加人id';
comment on column SYS_APP_VERSION.add_code
is '添加人编码';
comment on column SYS_APP_VERSION.add_name
is '添加人名称';
comment on column SYS_APP_VERSION.add_dept_code
is '添加部门编码';
comment on column SYS_APP_VERSION.add_dept_name
is '添加部门名称';
comment on column SYS_APP_VERSION.add_time
is '添加时间';
comment on column SYS_APP_VERSION.modify_id
is '修改人id';
comment on column SYS_APP_VERSION.modify_code
is '修改人编码';
comment on column SYS_APP_VERSION.modify_name
is '修改人名称';
comment on column SYS_APP_VERSION.modify_time
is '修改时间';
comment on column SYS_APP_VERSION.cancel_id
is '作废人id';
comment on column SYS_APP_VERSION.cancel_code
is '作废人编码';
comment on column SYS_APP_VERSION.cancel_name
is '作废人名称';
comment on column SYS_APP_VERSION.cancel_time
is '作废时间';
comment on column SYS_APP_VERSION.cancel_flag
is '作废标记';
comment on column SYS_APP_VERSION.belong_id
is 'BELONG_ID';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_APP_VERSION
add constraint SYS_APP_VERSION_PK primary key (ID)
using index
tablespace ${tableSpace}
pctfree 10
initrans 2
maxtrans 255
storage
(
initial 64K
next 1M
minextents 1
maxextents unlimited
);
