<!--${cfg.moduleName}-->
<template>
    <div>
        <el-card :body-style="cardBodyStyle">
            <el-form :model="query" label-position="right" label-width="80px" :inline="true">
                <#list table.fields as field>
                    <#list cfg.querys as query>
                        <#if field.name == query.fieldName>
                            <#if query.controllerType == "日期">
                                <el-form-item label="${field.comment}" class="no-show-error-message">
                                    <#if query.dateFlag =='1'>
                                        <el-date-picker v-model="query.${field.propertyName}" type="daterange"
                                                        size="small" align="right" unlink-panels range-separator="至"
                                                        start-placeholder="开始日期" end-placeholder="结束日期"
                                                        :picker-options="pickerOptions" style="width: 250px;"
                                                        value-format="yyyy-MM-dd">
                                        </el-date-picker>
                                    <#else>
                                        <el-date-picker v-model="query.${field.propertyName}" size="small" type="date"
                                                        value-format="yyyy-MM-dd"
                                                        style="width: 200px;"></el-date-picker>
                                    </#if>
                                </el-form-item>
                            <#elseif query.controllerType == "日期时间">
                                <el-form-item label="${field.comment}" class="no-show-error-message">
                                    <#if query.dateFlag =='1'>
                                        <el-date-picker v-model="query.${field.propertyName}" type="datetimerange"
                                                        size="small" align="right" unlink-panels range-separator="至"
                                                        start-placeholder="开始日期" end-placeholder="结束日期"
                                                        :picker-options="pickerOptions" style="width: 350px;"
                                                        value-format="yyyy-MM-dd HH:mm:ss">
                                        </el-date-picker>
                                    <#else>
                                        <el-date-picker v-model="query.${field.propertyName}" size="small"
                                                        type="datetime" value-format="yyyy-MM-dd HH:mm:ss"
                                                        style="width: 200px;"></el-date-picker>
                                    </#if>
                                </el-form-item>
                            <#else>
                                <el-form-item label="${field.comment}" class="no-show-error-message">
                                    <el-input v-model="query.${field.propertyName}" size="small" clearable
                                              style="width: 200px;"></el-input>
                                </el-form-item>
                            </#if>
                        </#if>
                    </#list>
                </#list>
            </el-form>
        </el-card>
        <el-card :body-style="cardBodyStyle">
            <sx-button @search="handleSearch" @add="handleAdd" @remove="handleRemoveBatch" @edit="handleEditBatch"
                       @upload="handleUpload" @download="handleDownload" @import="handleImport"
                       @exportSelection="handleExportSelection" @exportAll="handleExportAll"></sx-button>
        </el-card>
        <el-card :body-style="cardBodyStyle">
            <el-table :data="tableData" border highlight-current-row v-loading="loading"
                      @selection-change="handleSelectionChange" <#if cfg.fixedFlag == '0'> @header-dragend="handleDragend"  </#if> >
                <el-table-column type="selection" fixed></el-table-column>
                <el-table-column type="index" label="序号" align="center" width="60" fixed>
                    <template slot-scope="scope">
                        <span>{{ scope.$index + (currentPage - 1) * pageSize + 1 }}</span>
                    </template>
                </el-table-column>
                <#if cfg.fixedFlag == '0'>
                    <el-table-column v-for="item in cols" :key="item.id" :prop="item.prop" :label="item.label"
                                     :width="item.width"
                                     show-overflow-tooltip :header-align="item.headerAlign" :align="item.align"
                                     :sortable="item.sortable=='1'"
                                     class-name="canDrag" :formatter="formatter">
                    </el-table-column>
                <#else>
                    <#list table.fields as field>
                        <#list cfg.columns as column>
                            <#if field.name == column.fieldName>
                                <el-table-column prop="${field.propertyName}" label="${field.comment}"
                                                 width="${column.width}" header-align="center" align="${column.align}"
                                                 show-overflow-tooltip>
                                </el-table-column>
                            </#if>
                        </#list>
                    </#list>
                </#if>
                <el-table-column label="操作" header-align="center" align="center" width="320px" fixed="right">
                    <template slot-scope="scope">
                        <span v-if="!scope.row.processInstanceStatus||scope.row.processInstanceStatus ==''">
                          <el-button type="success" size="mini" plain @click="handleStart(scope.row)">提交
                          </el-button>
                        </span>
                        <span v-if="scope.row.processInstanceStatus =='撤回'||scope.row.processInstanceStatus =='驳回'">
                          <el-button type="primary" size="mini" plain @click="handleRestart(scope.row)">提交
                          </el-button>
                        </span>
                        <span v-if="scope.row.processInstanceStatus =='撤回'||scope.row.processInstanceStatus =='驳回'||!scope.row.processInstanceStatus||scope.row.processInstanceStatus ==''">
                          <el-button size="mini" plain type="danger" @click="handleRemove(scope.row)">删除</el-button>
                        </span>
                        <span v-if="scope.row.processInstanceStatus =='撤回'||scope.row.processInstanceStatus =='驳回'||!scope.row.processInstanceStatus||scope.row.processInstanceStatus ==''">
                          <el-button size="mini" plain type="warning" @click="handleEdit(scope.row)">编辑</el-button>
                        </span>
                        <span v-if="scope.row.processInstanceStatus =='审批中'">
                          <el-button size="mini" plain @click="handleCallBack(scope.row)">撤回</el-button>
                        </span>
                        <span v-if="scope.row.processInstanceStatus =='审批中'||scope.row.processInstanceStatus =='结束'">
                          <el-button size="mini" plain @click="handleDetail(scope.row)">查看</el-button>
                        </span>
                        <el-button size="mini" plain type="info" @click="handleAttachment(scope.row)">附件</el-button>
                    </template>
                </el-table-column>
            </el-table>
            <el-pagination :page-size="pageSize" @size-change="handleSizeChange" @current-change="handleCurrentChange"
                           :current-page="currentPage" background layout="total, sizes, prev, pager, next"
                           :total="totalRows">
            </el-pagination>
        </el-card>


        <el-dialog title="操作" :visible.sync="dialogVisible" width="1000px" :close-on-click-modal="false" v-dialogDrag>
            <el-form :model="form" :rules="rules" ref="form" label-position="right" label-width="80px" :inline="true">
                <#list table.fields as field>
                    <#list cfg.forms as form>
                        <#if field.name == form.fieldName>
                            <#if form.controllerType == "单行文本">
                                <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                    <el-input v-model="form.${field.propertyName}" size="small"
                                              style="width: 200px;"></el-input>
                                </el-form-item>
                            <#elseif form.controllerType == "多行文本">
                                <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                    <el-input v-model="form.${field.propertyName}" size="small" type="textarea"
                                              :rows="2" style="width: 200px;"></el-input>
                                </el-form-item>
                            <#elseif form.controllerType == "日期">
                                <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                    <el-date-picker v-model="form.${field.propertyName}" size="small" type="date"
                                                    value-format="yyyy-MM-dd"
                                                    style="width: 200px;"></el-date-picker>
                                </el-form-item>
                            <#elseif form.controllerType == "日期时间">
                                <el-form-item label="${field.comment}" prop="${field.propertyName}">
                                    <el-date-picker v-model="form.${field.propertyName}" size="small" type="datetime"
                                                    value-format="yyyy-MM-dd HH:mm:ss"
                                                    style="width: 200px;"></el-date-picker>
                                </el-form-item>
                            </#if>
                        </#if>
                    </#list>
                </#list>
                <el-form-item label="所属部门">
                    <el-select v-model="dept.name" size="small" style="width: 100px;" @change="addDeptChange">
                        <el-option v-for="item in depts" :key="item.id" :label="item.deptName" :value="item">
                        </el-option>
                    </el-select>
                </el-form-item>
            </el-form>
            <span slot="footer" class="dialog-footer">
        <el-button size="mini" @click="handleCancelSave">取消</el-button>
        <el-button type="success" size="mini" @click="handleSave('form')">保存</el-button>
      </span>
        </el-dialog>

        <popup-user-select-start :processSelect="processSelect" ref="popupUserSelectStart" v-on:search="handleSearch">
        </popup-user-select-start>
        <popup-attachment ref="PopupAttachment"></popup-attachment>
    </div>
</template>

<script>
    import tools from '@/tools'
    import axios from '@/axios'
    import SxButton from '@/components/system/SxButton.vue'
    import PopupAttachment from '@/components/system/PopupAttachment.vue'
    import PopupUserSelectStart from '@/view/process/PopupUserSelectStart.vue'
    import {
        mapState
    } from 'vuex'
    export default {
        computed: {
            ...mapState({
                serverName: state => state.app.serverName
            })
        },
        components: {
            SxButton,
            PopupAttachment,
            PopupUserSelectStart
        },
        data() {
            return {
                <#if cfg.fixedFlag == '0'>
                cols: [],
                tName: '${cfg.tName}',
                </#if>
                processSelect: {},
                depts: JSON.parse(localStorage.getItem('dept')),
                dept: {
                    name: JSON.parse(localStorage.getItem('dept'))[0].deptName,
                },
                cardBodyStyle: tools.style.card,
                tableData: [],
                multipleSelection: [],
                loading: false,
                currentPage: 1,
                totalRows: 0,
                pageSizes: [10, 20, 30, 40],
                pageSize: 10,
                dialogVisible: false,
                query: {
            <#list table.fields as field>
            <#list cfg.querys as query>
            <#if field.name == query.fieldName>
            <#if query.dateFlag =='1'>
            ${field.propertyName}:
            ['', ''],
            <#else>
            ${field.propertyName}:
            '',
            </#if>
            </#if>
            </#list>
            </#list>
        }<#noparse></#noparse>,
            form: {
                <#list table.fields as field>
                ${field.propertyName}:
                '',
                </#list>
            }
            <#noparse></#noparse>,
            rules: {
                <#list table.fields as field>
                <#list cfg.forms as form>
                <#if field.name == form.fieldName && form.requireFlag =='1'>
                ${field.propertyName}:
                [{required: true, message: '请输入${field.comment}', trigger: 'blur'}]<#sep>,
                </#if>
                </#list>
                </#list>
            }
        ,
            pickerOptions: {
                shortcuts: [{
                    text: '最近一周',
                    onClick(picker) {
                        const end = new Date();
                        const start = new Date();
                        start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
                        picker.$emit('pick', [start, end]);
                    }
                }, {
                    text: '最近一个月',
                    onClick(picker) {
                        const end = new Date();
                        const start = new Date();
                        start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
                        picker.$emit('pick', [start, end]);
                    }
                }, {
                    text: '最近三个月',
                    onClick(picker) {
                        const end = new Date();
                        const start = new Date();
                        start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
                        picker.$emit('pick', [start, end]);
                    }
                }]
            }
        ,
        }
        },
        methods: {
            handleSizeChange(val) {
                this.pageSize = val
                this.getTableData()
            },
            handleCurrentChange(val) {
                this.currentPage = val
                this.getTableData()
            },
            handleSelectionChange(val) {
                this.multipleSelection = val;
            },
            addDeptChange(item) {
                this.dept.name = item.deptName
                this.form.addDeptCode = item.deptCode
                this.form.addDeptName = item.deptName
            },
            getTableData() {
                this.loading = true
                var url = '${cfg.serviceName}/${entity}/queryPage.do'
                var param = {
                    page: this.currentPage,
                    rows: this.pageSize,
                    <#list table.fields as field>
                    <#list cfg.querys as query>
                    <#if field.name == query.fieldName>
                    <#if query.controllerType == "日期" || query.controllerType == "日期时间" >
                    <#if query.dateFlag =='1'>
                    ${field.propertyName}Begin: tools.date.getDateRangeBegin(this.query.${field.propertyName}),
                    ${field.propertyName}End: tools.date.getDateRangeEnd(this.query.${field.propertyName}),
                    <#else>
                    ${field.propertyName}Begin: tools.date.getDateBegin(this.query.${field.propertyName}),
                    ${field.propertyName}End: tools.date.getDateEnd(this.query.${field.propertyName}),
                </#if>
                <#else>
                ${field.propertyName}:
                this.query.${field.propertyName},
                </#if>
                </#if>
                </#list>
                </#list>
            }
                axios.get(url, param).then(response => {
                    if (response.data.code == '0') {
                        this.tableData = response.data.data.list
                        this.totalRows = response.data.data.total
                    } else {
                        this.$message({
                            type: 'error',
                            message: '操作失败!' + response.data.msg
                        });
                    }
                    this.loading = false
                });
            },
            handleSearch() {
                this.currentPage = 1
                this.getTableData()
            },
            handleAdd() {
                this.dialogVisible = true
                this.form = {
                    id: '',
                    addId: localStorage.getItem('userId'),
                    addCode: localStorage.getItem('userCode'),
                    addName: localStorage.getItem('userName'),
                    addDeptCode: this.depts[0].deptCode,
                    addDeptName: this.depts[0].deptName,
                }
            },
            handleCancelSave() {
                this.dialogVisible = false
            },

            handleSave(form) {
                this.$refs[form].validate((valid) => {
                    if (valid) {
                        var url = '${cfg.serviceName}/${entity}/save.do'
                        var json = JSON.stringify(this.form)
                        var param = {
                            json: json
                        }
                        axios.post(url, param).then(response => {
                            if (response.data.code == '0') {
                                this.$message({
                                    type: 'success',
                                    message: '操作成功!',
                                });
                                this.getTableData()
                                this.dialogVisible = false
                            } else {
                                this.$message({
                                    type: 'error',
                                    message: '操作失败!' + response.data.msg
                                });
                            }
                        })
                    } else {
                        console.com.shinsoft.log('error submit!!');
                        return false;
                    }
                })
            },
            handleRemove(row) {
                this.$confirm('此操作将删除该数据, 是否继续?', '提示', {
                    confirmButtonText: '确定',
                    cancelButtonText: '取消',
                    type: 'warning'
                }).then(() => {
                    var url = '${cfg.serviceName}/${entity}/remove.do'
                    var param = {
                        id: row.id
                    }
                    axios.post(url, param).then(response => {
                        if (response.data.code == '0') {
                            this.$message({
                                type: 'success',
                                message: '操作成功!',
                            });
                            this.getTableData()
                            this.dialogVisible = false
                        } else {
                            this.$message({
                                type: 'error',
                                message: '操作失败!' + response.data.msg
                            });
                        }
                    })
                }).catch(() => {
                    this.$message({
                        type: 'info',
                        message: '已取消删除'
                    })
                })
            },

            handleRemoveBatch() {
                if (this.multipleSelection.length < 1) {
                    this.$message({
                        type: 'warning',
                        message: '请选择要删除的数据!'
                    })
                    return
                }
                this.$confirm('此操作将删除该数据, 是否继续?', '提示', {
                    confirmButtonText: '确定',
                    cancelButtonText: '取消',
                    type: 'warning'
                }).then(() => {
                    var ids = []
                    this.multipleSelection.forEach((item, index) => {
                        ids.push(item.id)
                    })
                    var url = '${cfg.serviceName}/${entity}/removeBatch.do'
                    var param = {
                        ids: ids
                    }
                    axios.post(url, param).then(response => {
                        if (response.data.code == '0') {
                            this.$message({
                                type: 'success',
                                message: '操作成功!',
                            });
                            this.getTableData()
                            this.dialogVisible = false
                        } else {
                            this.$message({
                                type: 'error',
                                message: '操作失败!' + response.data.msg
                            });
                        }
                    })
                }).catch(() => {
                    this.$message({
                        type: 'info',
                        message: '已取消删除'
                    })
                })
            },

            handleEdit(row) {
                this.form = row
                this.dialogVisible = true
            },

            handleEditBatch() {
                if (this.multipleSelection.length != 1) {
                    this.$message({
                        type: 'warning',
                        message: '请选择一条数据编辑!'
                    })
                    return
                }
                this.form = this.multipleSelection[0]
                this.dialogVisible = true
            },

            handleStart(row) {
                var url = '${cfg.serviceName}/${entity}/start.do'
                var param = {
                    id: row.id
                }
                axios.post(url, param).then(response => {
                    if (response.data.code == '0') {
                        this.$message({
                            type: 'success',
                            message: '操作成功!',
                        })
                        if (response.data.data.type == "yes") {
                            this.processSelect = response.data.data
                            this.$refs.popupUserSelectStart.show()
                        }
                        this.getTableData()
                    } else {
                        this.$message({
                            type: 'error',
                            message: '操作失败!' + response.data.msg
                        });
                    }
                })
            },

            handleRestart(row) {
                var url = 'activiti/Process/restart.do'
                var param = {
                    processInstanceId: row.processInstanceId,
                    businessId: row.id
                }
                axios.post(url, param).then(response => {
                    if (response.data.code == '0') {
                        this.$message({
                            type: 'success',
                            message: '操作成功!',
                        })
                        if (response.data.data.type == "yes") {
                            this.processSelect = response.data.data
                            this.$refs.popupUserSelectStart.show()
                        }
                        this.getTableData()
                    } else {
                        this.$message({
                            type: 'error',
                            message: '操作失败!' + response.data.msg
                        });
                    }
                })
            },
            handleCallBack(row) {
                var url = 'activiti/Callback/callback.do'
                var param = {
                    processInstanceId: row.processInstanceId,
                }
                axios.get(url, param).then(response => {
                    console.com.shinsoft.log(JSON.stringify(response.data))
                    if (response.data.code == 0) {
                        this.$message({
                            type: 'success',
                            message: '操作成功!',
                        });
                        this.getTableData()
                    } else {
                        this.$message({
                            type: 'error',
                            message: '操作失败！' + response.data.msg
                        });
                    }
                });
            },
            handleDetail(row) {
                var url = 'activiti/Process/queryForDetail.do'
                var param = {
                    processInstanceId: row.processInstanceId,
                }
                axios.post(url, param).then(response => {
                    if (response.data.code == 0) {
                        this.$store.commit('setProcessKey', response.data.data.processKey)
                        this.$store.commit('setTableName', response.data.data.tableName)
                        this.$store.commit('setProcessInstanceId', row.processInstanceId)
                        this.$store.commit('setBusinessId', row.id)
                        this.$router.push({
                            path: '/process/historyActInst',
                        })
                    } else {
                        this.$message({
                            type: 'error',
                            message: '操作失败！' + response.data.msg
                        });
                    }
                });
            },
            <#if cfg.fixedFlag == '0'>
            getCols() {
                var url = 'framework/TablePersonal/queryByUserIdMenuId.do'
                var param = {
                    menuId: localStorage.getItem('menuId'),
                    tName: this.tName
                }
                axios.get(url, param).then(response => {
                    var temp = [];
                    for (var col of response.data.data) {
                        if (col.showFlag == '1') {
                            temp.push(col)
                        }
                    }
                    var newArray = temp.slice(0);
                    this.cols = [];
                    this.$nextTick(() => {
                        this.cols = newArray;
                    });
                });
            },
            handleDragend(newWidth, oldWidth, column, event) {
                var url = 'framework/TablePersonal/widthDragend.do'
                var param = {
                    menuId: localStorage.getItem('menuId'),
                    prop: column.property,
                    width: newWidth,
                    tName: this.tName
                }
                axios.post(url, param).then(response => {
                });
            },
            formatter(row, column, cellValue, index) {
                // if (column.property == 'memo') {
                //     return row.userName + '-' + row.userDesc
                // }
                return cellValue
            },
            </#if>
            handleAttachment(row) {
                var buttonDisabled = false
                if (row.processInstanceStatus) {
                    if (row.processInstanceStatus == '撤回' || row.processInstanceStatus == '驳回' || row.processInstanceStatus ==
                        '结束') {
                        buttonDisabled = false
                    } else {
                        buttonDisabled = true
                    }
                } else {
                    buttonDisabled = false
                }
                this.$refs.PopupAttachment.show(row.id, buttonDisabled)
            },
            handleUpload() {
                console.com.shinsoft.log('handleUpload')
            },
            handleDownload() {
                console.com.shinsoft.log('handleDownload')
            },
            handleImport() {
                console.com.shinsoft.log('handleImport')
            },
            handleExportSelection() {
                if (this.multipleSelection == null || this.multipleSelection.length == 0) {
                    this.$message({
                        type: 'error',
                        message: '请选择导出数据！'
                    });
                    return
                }
                const header = []
                const headerProp = []
                for (var col of this.cols) {
                    if (col.exportFlag == '1') {
                        header.push(col.label)
                        headerProp.push(col.prop)
                    }
                }
                const data = tools.Export2Excel.formatJson(headerProp, this.multipleSelection)
                const filename = '导出' + (new Date()).toLocaleDateString();
                tools.Export2Excel.export_json_to_excel({
                    header,
                    data,
                    filename
                })
            },
            handleExportAll() {
                let param = ''
                param += '?userId=' + localStorage.getItem('userId')
                param += '&menuId=' + localStorage.getItem('menuId')
                param += '&belongId=' + localStorage.getItem('belongId')
                param += '&tName=' + this.tName
                <#list table.fields as field>
                <#list cfg.querys as query>
                <#if field.name == query.fieldName>
                <#if query.controllerType == "日期" || query.controllerType == "日期时间" >
                <#if query.dateFlag =='1'>
                    param += '&${field.propertyName}Begin='+ tools.date.getDateRangeBegin(this.query.${field.propertyName})
                    param += '&${field.propertyName}End='+tools.date.getDateRangeEnd(this.query.${field.propertyName})
                    <#else>
                    param += '&${field.propertyName}Begin='+  tools.date.getDateBegin(this.query.${field.propertyName})
                    param += '&${field.propertyName}End='+  tools.date.getDateEnd(this.query.${field.propertyName})
                </#if>
                <#else>
                        param += '&${field.propertyName}='+   this.query.${field.propertyName}
                    </#if>
                    </#if>
                    </#list>
                    </#list>
                window.open(this.serverName + '/${cfg.serviceName}/${entity}/export.do' + param);
            },

        },
        mounted() {
            <#if cfg.fixedFlag == '0'>
            this.getCols()
            </#if>
            <#--            <#list table.fields as field>-->
            <#--                <#list cfg.querys as query>-->
            <#--                    <#if field.name == query.fieldName>-->
            <#--                        <#if query.controllerType =='日期'>-->
            <#--                this.query.${field.propertyName} = date.getDate()-->
            <#--                        <#elseif query.controllerType =='日期时间'>-->
            <#--                this.query.${field.propertyName} = date.getDateTime()-->
            <#--                        </#if>-->
            <#--                    </#if>-->
            <#--                </#list>-->
            <#--            </#list>-->
        }


    }
</script>

<style>
</style>
