-- Create table
create table EXP_SEARCH_MASTER
(
master_name             VARCHAR2(50),
id                      VARCHAR2(32) not null,
process_instance_id     VARCHAR2(32),
process_instance_status VARCHAR2(50),
add_id                  VARCHAR2(32),
add_code                VARCHAR2(50),
add_name                VARCHAR2(50),
add_dept_id             VARCHAR2(50),
add_dept_code           VARCHAR2(50),
add_dept_name           VARCHAR2(50),
add_time                DATE,
modify_id               VARCHAR2(32),
modify_code             VARCHAR2(50),
modify_name             VARCHAR2(50),
modify_time             DATE,
cancel_id               VARCHAR2(32),
cancel_code             VARCHAR2(50),
cancel_name             VARCHAR2(50),
cancel_time             DATE,
cancel_flag             VARCHAR2(50),
belong_id               VARCHAR2(32)
)
tablespace ${tableSpace}
pctfree 10
initrans 1
maxtrans 255
storage
(
initial 16K
next 8K
minextents 1
maxextents unlimited
);
-- Add comments to the columns
comment on column EXP_SEARCH_MASTER.master_name
is '主表名称';
comment on column EXP_SEARCH_MASTER.id
is '主键';
comment on column EXP_SEARCH_MASTER.process_instance_id
is '流程id';
comment on column EXP_SEARCH_MASTER.process_instance_status
is '流程状态';
comment on column EXP_SEARCH_MASTER.add_id
is '添加人id';
comment on column EXP_SEARCH_MASTER.add_code
is '添加人编码';
comment on column EXP_SEARCH_MASTER.add_name
is '添加人名称';
comment on column EXP_SEARCH_MASTER.add_dept_id
is '添加部门id';
comment on column EXP_SEARCH_MASTER.add_dept_code
is '添加部门编码';
comment on column EXP_SEARCH_MASTER.add_dept_name
is '添加部门名称';
comment on column EXP_SEARCH_MASTER.add_time
is '添加时间';
comment on column EXP_SEARCH_MASTER.modify_id
is '修改人id';
comment on column EXP_SEARCH_MASTER.modify_code
is '修改人编码';
comment on column EXP_SEARCH_MASTER.modify_name
is '修改人名称';
comment on column EXP_SEARCH_MASTER.modify_time
is '修改时间';
comment on column EXP_SEARCH_MASTER.cancel_id
is '作废人id';
comment on column EXP_SEARCH_MASTER.cancel_code
is '作废人编码';
comment on column EXP_SEARCH_MASTER.cancel_name
is '作废人名称';
comment on column EXP_SEARCH_MASTER.cancel_time
is '作废时间';
comment on column EXP_SEARCH_MASTER.cancel_flag
is '作废标记';
comment on column EXP_SEARCH_MASTER.belong_id
is 'BELONG_ID';
-- Create/Recreate primary, unique and foreign key constraints
alter table EXP_SEARCH_MASTER
add constraint EXP_SEARCH_MASTER_PK primary key (ID)
using index
tablespace ${tableSpace}
pctfree 10
initrans 2
maxtrans 255
storage
(
initial 64K
next 1M
minextents 1
maxextents unlimited
);
